import 'package:dio/dio.dart';
import 'package:razinsoft_rider/domain/interfaces/payment_confirm_service_interface.dart';

import '../../core/config/api_endpoints.dart';
import 'api/dio_client.dart';

class PaymentConfirmService implements IPaymentConfirmService {
  final DioClient dioClient;

  PaymentConfirmService({required this.dioClient});
  @override
  Future<Response> paymentConfirm({required int orderId, required String paymentMethodName}) async => await dioClient.dio
        .post(ApiEndpoints.paymentConfirm, data: {
          'order_id': orderId,
          'payment_method': paymentMethodName
    });

  @override
  Future<Response> hitSuccessUrl({required String url}) async => await dioClient.dio
        .get(url,);

}
